import { useState, useEffect } from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  const images = [
    '/images/drawing-1.jpg',
    '/images/drawing-2.jpg',
    '/images/drawing-3.jpg',
    '/images/drawing-4.jpg'
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-elegant">
      <div className="slider-wrapper-elegant">
        <AnimatePresence mode="wait">
          <motion.div
            key={currentIndex}
            className="slide-elegant"
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            exit={{ opacity: 0 }}
            transition={{ duration: 0.5 }}
            style={{ backgroundImage: `url(${images[currentIndex]})` }}
          >
            <div className="slide-overlay-elegant"></div>
          </motion.div>
        </AnimatePresence>

        <motion.button 
          className="slider-btn-elegant slider-btn-prev-elegant" 
          onClick={goToPrevious}
          whileHover={{ scale: 1.05 }}
          whileTap={{ scale: 0.95 }}
        >
          <ChevronLeft size={20} strokeWidth={1.5} />
        </motion.button>
        <motion.button 
          className="slider-btn-elegant slider-btn-next-elegant" 
          onClick={goToNext}
          whileHover={{ scale: 1.05 }}
          whileTap={{ scale: 0.95 }}
        >
          <ChevronRight size={20} strokeWidth={1.5} />
        </motion.button>

        <div className="slider-dots-elegant">
          {images.map((_, index) => (
            <motion.button
              key={index}
              className={`dot-elegant ${index === currentIndex ? 'active' : ''}`}
              onClick={() => goToSlide(index)}
              whileHover={{ scale: 1.2 }}
              whileTap={{ scale: 0.9 }}
              aria-label={`Go to slide ${index + 1}`}
            />
          ))}
        </div>
      </div>
    </div>
  )
}

export default ImageSlider

